import { Injectable } from '@angular/core'
import { Http, Response } from '@angular/http'
import { Observable } from 'rxjs/Rx'
import { MainContent } from './maincontent'
import { Product } from './product'
import { ProductLink } from './product-link'

@Injectable()
export class MainContentService {

  private maincontent: any;

  constructor(private http: Http) { }

  getContent(): Observable<MainContent> {
    return this.http.get('../../assets/config/maincontent.json').map(mapMainContent)
  }

  getProduct(productname: string): Observable<Product> {
    return this.http.get('../../assets/config/maincontent.json')
      .map(res => {
        let r = res.json()
        let products: Array<Product> = r["product"]

        for (let i = 0; i < products.length; i++) {
          if (productname === products[i].name.toLowerCase()) {

            let prod: Product = new Product()
            prod.name = products[i].name
            prod.erevenueUrl = products[i].erevenueUrl

            let links = products[i].links
            if (links) {
              for (let j = 0; j < links.length; j++) {
                let link: ProductLink = new ProductLink()
                link.name = links[j].name
                link.uri = links[j].uri
                prod.links.push(link)
              }
            }
            return prod
          }
        }

        return null
      })

  }

}

function mapMainContent(response: Response): MainContent {
  let r = response.json()
  let mc = new MainContent()
  let products: Array<Product> = r["product"]

  for (let i = 0; i < products.length; i++) {
    let prod: Product = new Product()

    prod.name = products[i].name
    prod.erevenueUrl = products[i].erevenueUrl
    prod.showbox = products[i].showbox

    let links = products[i].links
    if (links) {
      for (let j = 0; j < links.length; j++) {
        let link: ProductLink = new ProductLink()
        link.name = links[j].name
        link.uri = links[j].uri
        prod.links.push(link)
      }
    }
    mc.product.push(prod)
  }

  mc.phone = r["phone"]
  mc.emailText = r["emailText"]
  mc.emailValue = r["emailValue"]

  return mc
}
